class DM_SB extends TournamentScoreBoard;

var localized string MapTitle, Author, Restart, Continue, Ended, ElapsedTime, RemainingTime, FragGoal, TimeLimit;
var localized string PlayerString, FragsString, DeathsString, PingString, EffString;
var localized string TimeString, LossString, FPHString;
var color GreenColor, LGreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor;
var PlayerReplicationInfo Ordered[32];
var float ScoreStart;	// top allowed score start
var float FrameBorder;	// space at the sides of the frame
var bool bTimeDown;
var FontInfo MyFonts;
var localized string MapTitleQuote;
var int dice, diceb, drawtime;
var float a;

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
	ScoreStart = 80;
}

function DrawHeader( canvas Canvas )
{
local GameReplicationInfo GRI;
local float XL, YL;
local font CanvasFont;

	DrawBabes(Canvas);

	//Draw Scoreboard logo:
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = BronzeColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, 0);
	Canvas.DrawTile(Texture'SBlogo', 512, 64, 0, 0, 512, 64);
	Canvas.Style = ERenderStyle.STY_Normal;

	Canvas.DrawColor = WhiteColor;
	GRI = PlayerPawn(Owner).GameReplicationInfo;
	Canvas.bCenter = True;
	
	Canvas.Font = MyFonts.GetHugeFont(Canvas.ClipX);
	
	Canvas.StrLen("Test", XL, YL);
	CanvasFont = Canvas.Font;
	if ( GRI.GameEndedComments != "" )
	{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, 80);
		Canvas.DrawText(GRI.GameEndedComments, True);
	}
	else
	{
		Canvas.SetPos(0, 2);
		DrawVictoryConditions(Canvas);
	}
	Canvas.bCenter = False;
	Canvas.Font = CanvasFont;
}

function DrawVictoryConditions(Canvas Canvas)
{
local TournamentGameReplicationInfo TGRI;
local float XL, YL;


	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	//Canvas.DrawText(TGRI.GameName);
	//Canvas.StrLen("Test", XL, YL);
	//Canvas.SetPos(0, Canvas.CurY - YL);

	Canvas.SetPos(0, 64);
	
	if ( TGRI.FragLimit > 0 && TGRI.TimeLimit > 0)
		{
		Canvas.DrawText(FragGoal@TGRI.FragLimit$","@TimeLimit@TGRI.TimeLimit$":00");
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.CurY - YL);
		}
	else if ( TGRI.FragLimit > 0 )
		{
		Canvas.DrawText(FragGoal@TGRI.FragLimit);
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.CurY - YL);
		}

	else if ( TGRI.TimeLimit > 0 )
		Canvas.DrawText(TimeLimit@TGRI.TimeLimit$":00");
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTrailer( canvas Canvas )
{
local int Hours, Minutes, Seconds;
local float XL, YL, Xpos, Offset, X;
local PlayerPawn PlayerOwner;
local string Line1;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 3 * YL);
	if ( (Level.NetMode == NM_Standalone) && Level.Game.IsA('DeathMatchPlus') )
	{
		if ( DeathMatchPlus(Level.Game).bRatedGame )
			Canvas.DrawText(DeathMatchPlus(Level.Game).RatedGameLadderObj.SkillText@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else if ( DeathMatchPlus(Level.Game).bNoviceMode ) 
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else  
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty + 4]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
	}
	else
		Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
	
	Line1 = "Press F2 to view all-time server statistics";
	Canvas.StrLen(Line1, XL, YL);
	Xpos = Canvas.ClipX * 0.5 - 0.5 * XL;
	Offset = Canvas.ClipY - YL;
	
	X = Cos(a);

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Xpos - X * 50, Offset);
	Canvas.DrawText(Line1, False);
}

simulated function Tick(float DeltaTime)
{
local int i;
local Canvas Canvas;

	Super.Tick(DeltaTime);
	
	a -= 0.025;
	if ( a < 0 )
		{
		a = 6.283185307;
		}
}

function DrawCategoryHeaders(Canvas Canvas)
{
local float Offset, XL, YL, Xstart, Xlength;

	Offset = Canvas.CurY + 4;
	Xstart = FrameBorder;					//Space left and right of the frame
	Xlength = Canvas.ClipX - (2 * Xstart );	//The Width of the frame
	Canvas.StrLen(PlayerString, XL, YL);
	
	//Draw Top line of frame:
	Canvas.DrawColor = SilverColor;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Xstart, Offset);
	Canvas.DrawTile(Texture'WhiteDot', Xlength, 2, 0, 0, 2, 2);
	//Draw Left line of top frame:
	Canvas.SetPos(Xstart, Offset + 2);
	Canvas.DrawTile(Texture'WhiteDot', 2, YL - 2, 0, 0, 2, 2);
	//Draw Right line of top frame:
	Canvas.SetPos(Xstart + Xlength - 2, Offset + 2);
	Canvas.DrawTile(Texture'WhiteDot', 2, YL - 2, 0, 0, 2, 2);
	//Draw Bottom line of top frame:
	Canvas.SetPos(Xstart, Offset + YL);
	Canvas.DrawTile(Texture'WhiteDot', Xlength, 2, 0, 0, 2, 2);
	//Draw Background color of top frame:
	Canvas.DrawColor = LGreenColor;
	Canvas.SetPos(Xstart + 2, Offset + 2);
	Canvas.DrawTile(Texture'WhiteDot', Xlength - 4, YL -2, 0, 0, 2, 2);
	
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Xstart + 2, Offset);
	Canvas.DrawText(PlayerString);
	Canvas.SetPos(XStart + (Xlength * 0.4), Offset);
	Canvas.DrawText(FragsString);
	Canvas.SetPos(XStart + (Xlength * 0.5), Offset);
	Canvas.DrawText(DeathsString);
	Canvas.SetPos(XStart + (Xlength * 0.625), Offset);
	Canvas.DrawText(EffString);
}

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
local float XL, YL, XL2, YL2, XL3, YL3, Xstart, Xlength, Eff;
local Font CanvasFont;
local bool bLocalPlayer;
local PlayerPawn PlayerOwner;
local int Time;

	PlayerOwner = PlayerPawn(Owner);

	bLocalPlayer = (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	Canvas.StrLen( "0000", XL, YL );
	
	Xstart = FrameBorder;					//Space left and right of the frame
	Xlength = Canvas.ClipX - (2 * Xstart );	//The Width of the frame
	Eff = PRI.Score /(PRI.Score + PRI.Deaths) * 100;
	if ( Eff < 0 )
		Eff = 0;
	
	//Draw Frames:
	Canvas.DrawColor = SilverColor;
	Canvas.Style = ERenderStyle.STY_Translucent;
	//Draw Left line of player frame:
	Canvas.SetPos(Xstart, YOffset - YL + 1);
	Canvas.DrawTile(Texture'WhiteDot', 2, YL - 2, 0, 0, 2, 2);
	//Draw Right line of player frame:
	Canvas.SetPos(Xstart + Xlength - 2, YOffset - YL + 1);
	Canvas.DrawTile(Texture'WhiteDot', 2, YL - 2, 0, 0, 2, 2);
	//Draw Bottom line of player frame:
	Canvas.SetPos(Xstart, YOffset - 1);
	Canvas.DrawTile(Texture'WhiteDot', Xlength, 2, 0, 0, 2, 2);
	//Draw name background:
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos(Xstart + 1, YOffset - YL + 2);
	Canvas.DrawTile(Texture'FadeA', 128, YL - 4, 0, 0, 128, 4);
	//Draw frags background:
	Canvas.SetPos(XStart + (Xlength * 0.4), YOffset - YL + 2);
	Canvas.DrawTile(Texture'FadeA', 32, YL - 4, 0, 0, 128, 4);
	//Draw deaths background:
	Canvas.DrawColor = RedColor;
	Canvas.SetPos(XStart + (Xlength * 0.5), YOffset - YL + 2);
	Canvas.DrawTile(Texture'FadeA', 32, YL - 4, 0, 0, 128, 4);
	//Draw eff background:
	if ( Eff == 100 )
		Canvas.DrawColor = WhiteColor;
	else if ( eff < 20 )
		Canvas.DrawColor = RedColor;
	else if ( PRI.Score == 0 && PRI.Deaths > 0 )
		Canvas.DrawColor = RedColor;
	else if ( eff < 50 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = GreenColor;
		
	Canvas.SetPos(XStart + (Xlength * 0.625), YOffset - YL + 2);
	Canvas.DrawTile(Texture'FadeA', 32, YL - 4, 0, 0, 128, 4);
	
	Canvas.Style = ERenderStyle.STY_Normal;
	
	// Draw Name
	if ( PRI.bAdmin )
		Canvas.DrawColor = WhiteColor;
	else if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else
		{
		Canvas.DrawColor.R = 0;
		Canvas.DrawColor.G = 0;
		Canvas.DrawColor.B = 0;
		}
	
	Canvas.SetPos(Xstart + 2, YOffset - YL);
	Canvas.DrawText(PRI.PlayerName, False);

	// Draw Score
	if ( !bLocalPlayer )
		Canvas.DrawColor = WhiteColor;

	Canvas.SetPos( XStart + (Xlength * 0.4), YOffset - YL);
	Canvas.DrawText( int(PRI.Score), false );

	// Draw Deaths
	Canvas.SetPos( XStart + (Xlength * 0.5), YOffset - YL);
	Canvas.DrawText( int(PRI.Deaths), false );

	// Draw Eff
	Canvas.SetPos( XStart + (Xlength * 0.625), YOffset - YL);
	Canvas.DrawText( int(Eff)$"%", false );
	
	if ( (Canvas.ClipX > 512) && (Level.NetMode != NM_Standalone) )
	{
		Canvas.DrawColor = WhiteColor;
		Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);

		// Draw Time
		Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
		Canvas.TextSize( TimeString$": 999", XL3, YL3 );
		Canvas.SetPos( Xstart + Xlength - (2.5 * XL), YOffset - YL );
		Canvas.DrawText( TimeString$":"@Time, false );

		// Draw FPH
		Canvas.TextSize( FPHString$": 999", XL2, YL2 );
		Canvas.SetPos( Xstart + Xlength - (2.5 * XL), YOffset + 0.5 * YL - YL);
		Canvas.DrawText( FPHString$": "@int(60 * PRI.Score/Time), false );

		// Draw Ping
		if (!PRI.bIsabot)
			{
			Canvas.TextSize( PingString$":"@PRI.Ping, XL2, YL2 );
			Canvas.SetPos( Xstart + Xlength - XL2 - 2, YOffset - YL);
			Canvas.DrawText( PingString$":"@PRI.Ping, false );
			}
	}
}

function SortScores(int N)
{
	local int I, J, Max;
	local PlayerReplicationInfo TempPRI;
	
	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

function ShowScores( canvas Canvas )
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
	local float XL, YL, Scale;
	local float YOffset, YStart;
	local font CanvasFont;

	Canvas.Style = ERenderStyle.STY_Normal;

	// Header
	Canvas.SetPos(0, 0);
	DrawHeader(Canvas);

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}
	SortScores(PlayerCount);
	
	CanvasFont = Canvas.Font;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	Canvas.SetPos(0, 160.0/768.0 * Canvas.ClipY);
	DrawCategoryHeaders(Canvas);

	Canvas.StrLen( "TEST", XL, YL );
	YStart = Canvas.CurY;
	YOffset = YStart;
	if ( PlayerCount > 15 )
		PlayerCount = FMin(PlayerCount, (Canvas.ClipY - YStart)/YL - 1);

	Canvas.SetPos(0, 0);
	for ( I=0; I<PlayerCount; I++ )
	{
		YOffset = YStart + I * YL;
		DrawNameAndPing( Canvas, Ordered[I], 0, YOffset, false );
	}
	
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;
}

function DrawBabes(Canvas Canvas)
{
local float XL, YL;
local string BabeName;
local Texture BabeTexture;

	//roll the dices
	if (drawtime <= 0)
		{
		dice = rand(23);
		diceb = rand(23);
		drawtime = 400;
		}
	else
		drawtime--;

	Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);
	Canvas.StrLen( "TEST", XL, YL );
	
	//Draw left babe frame:
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = SilverColor;
	Canvas.SetPos(0, Canvas.ClipY * 0.5 - 129);							//top
	Canvas.DrawTile(Texture'WhiteDot', 130, 1, 0, 0, 2, 2);
	Canvas.SetPos(0, Canvas.ClipY * 0.5 - 128);							//left
	Canvas.DrawTile(Texture'WhiteDot', 1, 257 + YL, 0, 0, 2, 2);
	Canvas.SetPos(129, Canvas.ClipY * 0.5 - 128);						//right
	Canvas.DrawTile(Texture'WhiteDot', 1, 257 + YL, 0, 0, 2, 2);
	Canvas.SetPos(1, Canvas.ClipY * 0.5 + 128);							//middle
	Canvas.DrawTile(Texture'WhiteDot', 128, 1, 0, 0, 2, 2);
	Canvas.SetPos(1, Canvas.ClipY * 0.5 + 128 + YL);					//bottom
	Canvas.DrawTile(Texture'WhiteDot', 128, 1, 0, 0, 2, 2);
	
	//Draw right babe frame:
	Canvas.SetPos(Canvas.ClipX - 129, Canvas.ClipY * 0.5 - 129);		//top
	Canvas.DrawTile(Texture'WhiteDot', 130, 1, 0, 0, 2, 2);
	Canvas.SetPos(Canvas.ClipX - 129, Canvas.ClipY * 0.5 - 128);		//left
	Canvas.DrawTile(Texture'WhiteDot', 1, 257 + YL, 0, 0, 2, 2);
	Canvas.SetPos(Canvas.ClipX - 1, Canvas.ClipY * 0.5 - 128);			//right
	Canvas.DrawTile(Texture'WhiteDot', 1, 257 + YL, 0, 0, 2, 2);
	Canvas.SetPos(Canvas.ClipX - 128, Canvas.ClipY * 0.5 + 128);		//middle
	Canvas.DrawTile(Texture'WhiteDot', 128, 1, 0, 0, 2, 2);
	Canvas.SetPos(Canvas.ClipX - 128, Canvas.ClipY * 0.5 + 128 + YL);	//bottom
	Canvas.DrawTile(Texture'WhiteDot', 128, 1, 0, 0, 2, 2);
	
	//Draw random left babe:
	
	if ( dice == 0)
		{
		BabeTexture = Texture'IsisTaylor';
		BabeName = "Isis Taylor";
		}
	else if ( dice == 1)
		{
		BabeTexture = Texture'JenniferWhite';
		BabeName = "Jennifer White";
		}
	else if ( dice == 2)
		{
		BabeTexture = Texture'KaydenKross';
		BabeName = "Kayden Kross";
		}
	else if ( dice == 3)
		{
		BabeTexture = Texture'KristinaRose';
		BabeName = "Kristina Rose";
		}
	else if ( dice == 4)
		{
		BabeTexture = Texture'SunnyLeone';
		BabeName = "Sunny Leone";
		}
	else if ( dice == 5)
		{
		BabeTexture = Texture'ToriBlack';
		BabeName = "Tori Black";
		}
	else if ( dice == 6)
		{
		BabeTexture = Texture'AlettaOcean';
		BabeName = "Aletta Ocean";
		}
	else if ( dice == 7)
		{
		BabeTexture = Texture'AlexisTexas';
		BabeName = "Alexis Texas";
		}
	else if ( dice == 8)
		{
		BabeTexture = Texture'BellaMoretti';
		BabeName = "Bella Moretti";
		}
	else if ( dice == 9)
		{
		BabeTexture = Texture'BibiJones';
		BabeName = "Bibi Jones";
		}	
	else if ( dice == 10)
		{
		BabeTexture = Texture'BreanneBenson';
		BabeName = "Breanne Benson";
		}	
	else if ( dice == 11)
		{
		BabeTexture = Texture'JaydenJaymes';
		BabeName = "Jayden Jaymes";
		}	
	else if ( dice == 12)
		{
		BabeTexture = Texture'JennaHaze';
		BabeName = "Jenna Haze";
		}	
	else if ( dice == 13)
		{
		BabeTexture = Texture'JennaPresley';
		BabeName = "Jenna Presley";
		}	
	else if ( dice == 14)
		{
		BabeTexture = Texture'JuelzVentura';
		BabeName = "Juelz Ventura";
		}	
	else if ( dice == 15)
		{
		BabeTexture = Texture'JynxMaze';
		BabeName = "Jynx Maze";
		}	
	else if ( dice == 16)
		{
		BabeTexture = Texture'KagneyLinnKarter';
		BabeName = "Kagney Linn Karter";
		}	
	else if ( dice == 17)
		{
		BabeTexture = Texture'Katsuni';
		BabeName = "Katsuni";
		}
	else if ( dice == 18)
		{
		BabeTexture = Texture'MadelynMarie';
		BabeName = "Madelyn Marie";
		}
	else if ( dice == 19)
		{
		BabeTexture = Texture'MoniqueAlexander';
		BabeName = "Monique Alexander";
		}
	else if ( dice == 20)
		{
		BabeTexture = Texture'PriyaRai';
		BabeName = "Priya Rai";
		}
	else if ( dice == 21)
		{
		BabeTexture = Texture'SophiaSanti';
		BabeName = "Sophia Santi";
		}
	else
		{
		BabeTexture = Texture'Stoya';
		BabeName = "Stoya";
		}	
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(1, Canvas.ClipY * 0.5 - 128);
	Canvas.DrawTile(BabeTexture, 128, 256, 0, 0, 128, 256);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.StrLen(BabeName, XL, YL );
	Canvas.SetPos(130 * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 + 129);
	Canvas.DrawText(BabeName, false );
	
	//Draw random right babe:
	
	if ( dice == 0)
		{
		BabeTexture = Texture'IsisTaylor';
		BabeName = "Isis Taylor";
		}
	else if ( diceb == 1)
		{
		BabeTexture = Texture'JenniferWhite';
		BabeName = "Jennifer White";
		}
	else if ( diceb == 2)
		{
		BabeTexture = Texture'KaydenKross';
		BabeName = "Kayden Kross";
		}
	else if ( diceb == 3)
		{
		BabeTexture = Texture'KristinaRose';
		BabeName = "Kristina Rose";
		}
	else if ( diceb == 4)
		{
		BabeTexture = Texture'SunnyLeone';
		BabeName = "Sunny Leone";
		}
	else if ( diceb == 5)
		{
		BabeTexture = Texture'ToriBlack';
		BabeName = "Tori Black";
		}
	else if ( diceb == 6)
		{
		BabeTexture = Texture'AlettaOcean';
		BabeName = "Aletta Ocean";
		}
	else if ( diceb == 7)
		{
		BabeTexture = Texture'AlexisTexas';
		BabeName = "Alexis Texas";
		}
	else if ( diceb == 8)
		{
		BabeTexture = Texture'BellaMoretti';
		BabeName = "Bella Moretti";
		}
	else if ( diceb == 9)
		{
		BabeTexture = Texture'BibiJones';
		BabeName = "Bibi Jones";
		}	
	else if ( diceb == 10)
		{
		BabeTexture = Texture'BreanneBenson';
		BabeName = "Breanne Benson";
		}	
	else if ( diceb == 11)
		{
		BabeTexture = Texture'JaydenJaymes';
		BabeName = "Jayden Jaymes";
		}	
	else if ( diceb == 12)
		{
		BabeTexture = Texture'JennaHaze';
		BabeName = "Jenna Haze";
		}	
	else if ( diceb == 13)
		{
		BabeTexture = Texture'JennaPresley';
		BabeName = "Jenna Presley";
		}	
	else if ( diceb == 14)
		{
		BabeTexture = Texture'JuelzVentura';
		BabeName = "Juelz Ventura";
		}	
	else if ( diceb == 15)
		{
		BabeTexture = Texture'JynxMaze';
		BabeName = "Jynx Maze";
		}	
	else if ( diceb == 16)
		{
		BabeTexture = Texture'KagneyLinnKarter';
		BabeName = "Kagney Linn Karter";
		}	
	else if ( diceb == 17)
		{
		BabeTexture = Texture'Katsuni';
		BabeName = "Katsuni";
		}
	else if ( diceb == 18)
		{
		BabeTexture = Texture'MadelynMarie';
		BabeName = "Madelyn Marie";
		}
	else if ( diceb == 19)
		{
		BabeTexture = Texture'MoniqueAlexander';
		BabeName = "Monique Alexander";
		}
	else if ( diceb == 20)
		{
		BabeTexture = Texture'PriyaRai';
		BabeName = "Priya Rai";
		}
	else if ( diceb == 21)
		{
		BabeTexture = Texture'SophiaSanti';
		BabeName = "Sophia Santi";
		}
	else
		{
		BabeTexture = Texture'Stoya';
		BabeName = "Stoya";
		}
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX - 129, Canvas.ClipY * 0.5 - 128);
	Canvas.DrawTile(BabeTexture, 128, 256, 0, 0, 128, 256);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.StrLen(BabeName, XL, YL );
	Canvas.SetPos(Canvas.ClipX - 65 - 0.5 * XL, Canvas.ClipY * 0.5 + 129);
	Canvas.DrawText(BabeName, false );
}

defaultproperties
{
     MapTitle="in"
     Author="by"
     Restart="You are dead.  Hit [Fire] to respawn!"
     Continue=" Hit [Fire] to continue!"
     Ended="The match has ended."
     ElapsedTime="Elapsed Time: "
     RemainingTime="Remaining Time: "
     FragGoal="Frag Limit:"
     TimeLimit="Time Limit:"
     PlayerString="Player"
     FragsString="Frags"
     DeathsString="Deaths"
     PingString="Ping"
     EffString="Eff."
     TimeString="Time"
     LossString="Loss"
     FPHString="FPH"
     GreenColor=(G=255)
     LGreenColor=(G=155)
     WhiteColor=(R=255,G=255,B=255)
     GoldColor=(R=255,G=255)
     BlueColor=(B=255)
     LightCyanColor=(R=128,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     BronzeColor=(R=203,G=147,B=52)
     CyanColor=(G=128,B=255)
     RedColor=(R=255)
     FrameBorder=132.000000
}
